/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.speech;

import java.net.URL;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jemu.core.device.speech.DKTronics;
import jemu.core.device.speech.SSA1;
import jemu.system.cpc.CPC;

public class SPO256 {
    public static final boolean DEBUG = false;
    private SourceDataLine SPO256line = null;
    final String[] prefs = new String[]{"wavs/", "wava/"};
    boolean playing;

    public static void main(String[] args) {
        SPO256 SPO = new SPO256();
        SPO.Output("|JH|AA|PA3|VV|AA|PA2|SS|IY|PA2|PA3|PP|IY|PA2|SS|IY|PA5|PA5|PA5|EH|SS|PA2|PA3|PP|IY|PA2|OW|PA2|PA3|TT2|UW2|FF|AY|PA3|VV|SS|IH|PA3|KK1|SS|PA3|PA3|SS|PP|IY|CH|PA2|SS|YY1|NN1|TH|EH|SS|IH|SS|PA2|CH|IH|PP|PA2|RR2|EH|DD1|IY|PA2|PA3|TT2|UW2|PA2|EH|MM|AX|LL|EY|TT2|PA1|PA1|", 0);
    }

    public void Output(final String word, final int speechDevice) {
        Thread speaker = new Thread(){

            @Override
            public void run() {
                if (SPO256.this.playing) {
                    return;
                }
                SPO256.this.playing = true;
                byte[] previousSound = null;
                StringTokenizer st = new StringTokenizer(word, "|", false);
                while (st.hasMoreTokens()) {
                    String thisPhoneFile = st.nextToken();
                    thisPhoneFile = SPO256.this.prefs[speechDevice] + thisPhoneFile.toLowerCase() + ".wav";
                    byte[] thisSound = SPO256.this.getSound(thisPhoneFile);
                    if (previousSound != null) {
                        int mergeCount = 0;
                        if (previousSound.length >= 500 && thisSound.length >= 500) {
                            mergeCount = 500;
                        }
                        for (int i = 0; i < mergeCount; ++i) {
                            previousSound[previousSound.length - mergeCount + i] = (byte)((previousSound[previousSound.length - mergeCount + i] + thisSound[i]) / 2);
                        }
                        SPO256.this.playSound(previousSound);
                        byte[] newSound = new byte[thisSound.length - mergeCount];
                        for (int ii = 0; ii < newSound.length; ++ii) {
                            newSound[ii] = thisSound[ii + mergeCount];
                        }
                        previousSound = newSound;
                        continue;
                    }
                    previousSound = thisSound;
                }
                SPO256.this.playSound(previousSound);
                SSA1.LRQ = 0;
                SSA1.SBY = 0;
                DKTronics.LRQ = 127;
                CPC.speechCount = 0;
                SPO256.this.drain();
                SPO256.this.playing = false;
            }
        };
        speaker.start();
    }

    private void drain() {
        if (this.SPO256line != null) {
            this.SPO256line.drain();
        }
        try {
            Thread.sleep(100L);
            SSA1.LRQ = 128;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sayDKTronics() {
        this.Output("DD1|IY|PA3|KK1|EY|PA3|'|TT1|RR2|OW|NN1|IH|KK3|SS|", 0);
    }

    public void sayAmstrad() {
        this.Output("AA|MM|SS|TT1|RR2|AA|DD1|PA4|EH|SS|PA3|EH|SS|PA3|EY|PA3|WW|AO|NN1|", 1);
    }

    public void sayOkDK() {
        this.Output("OW|KK1|EY|", 0);
    }

    public void sayOkSSA() {
        this.Output("OW|KK1|EY|", 1);
    }

    private void playSound(byte[] data) {
        if (data != null && data.length > 0) {
            this.SPO256line.write(data, 0, data.length);
        }
    }

    private byte[] getSound(String fileName) {
        try {
            URL url = SPO256.class.getResource(fileName);
            AudioInputStream stream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = stream.getFormat();
            if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat tmpFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                stream = AudioSystem.getAudioInputStream(tmpFormat, stream);
                format = tmpFormat;
            }
            DataLine.Info info = new DataLine.Info(Clip.class, format, (int)stream.getFrameLength() * format.getFrameSize());
            if (this.SPO256line == null) {
                DataLine.Info outInfo = new DataLine.Info(SourceDataLine.class, format);
                if (!AudioSystem.isLineSupported(outInfo)) {
                    System.out.println("Line matching " + outInfo + " not supported.");
                    throw new Exception("Line matching " + outInfo + " not supported.");
                }
                this.SPO256line = (SourceDataLine)AudioSystem.getLine(outInfo);
                this.SPO256line.open(format, 50000);
                this.SPO256line.start();
            }
            int frameSizeInBytes = format.getFrameSize();
            int bufferLengthInFrames = this.SPO256line.getBufferSize() / 8;
            int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
            byte[] data = new byte[bufferLengthInBytes];
            int numBytesRead = 0;
            numBytesRead = stream.read(data);
            if (numBytesRead != -1) {
                int n = numBytesRead;
            }
            byte maxByte = 0;
            byte[] newData = new byte[numBytesRead];
            for (int i = 0; i < numBytesRead; ++i) {
                newData[i] = data[i];
                if (newData[i] <= maxByte) continue;
                maxByte = newData[i];
            }
            return newData;
        }
        catch (Exception e) {
            return new byte[0];
        }
    }
}

